/*******************************************************************
*
*  DESCRIPTION: Food Court Model
*
*  AUTHOR: Shagun Goel
*
*
*  
*
*******************************************************************/

#ifndef __cashier_H
#define __cashier_H

#include <list>
#include "atomic.h"     // class Atomic

class cashier : public Atomic
{
public:
	cashier( const string &name = "cashier" );	//Default constructor
	virtual ~cashier() { delete [] reqList; }
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &request;
	Port &out;
	Port &beReady;	
	typedef list<Value> ElementList ;
	ElementList elements;
	int *reqList;
	int request_count;
	int max_counters;
	int get_counter_id();

};	// class cashier

// ** inline ** // 
inline
string cashier::className() const
{
	return "cashier" ;
}

#endif   //__cashier_H
